<?php
// db.php - Conexão PDO com fallback para variáveis de ambiente
// Caminho sugerido: fora do webroot (ex: one level above htdocs) ou com permissão 600

// Tente pegar de variáveis de ambiente primeiro (mais seguro)
$host = getenv('DB_HOST') ?: 'localhost';
$db   = getenv('DB_NAME') ?: 'oldgrounds_buddypoke';
$user = getenv('DB_USER') ?: 'oldgrounds_buddy';
$pass = getenv('DB_PASS') ?: 'iuZgm7t6eeDaFMEyNk';

$dsn = "mysql:host={$host};dbname={$db};charset=utf8mb4";

$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (PDOException $e) {
    // loga o erro em arquivo de log do servidor (NÃO exponha a mensagem ao cliente)
    error_log("DB connect error: " . $e->getMessage());
    http_response_code(500);
    // resposta genérica — db.php normalmente não é acessado diretamente pelo SWF
    echo json_encode(['error' => 'DB connection failed']);
    exit;
}
